### 1. Инициализация проекта

Создание нового локального репозитория в текущей папке:

```
git init
```

### 2. Просмотр текущего состояния

Показывает изменённые, подготовленные и неотслеживаемые файлы:

```
git status
```

### 3. Добавление файлов в индекс (stage)

Добавление одного файла:

```
git add имя_файла
```

Добавление всех файлов в каталоге и подкаталогах:

```
git add .
```

Добавление абсолютно всех изменений (включая удалённые файлы):

```
git add -A
```

### 4. Фиксация изменений (создание коммита)

Обычный коммит с открытием редактора:

```
git commit
```

Коммит с комментарием в одной строке:

```
git commit -m "Краткое описание внесённых изменений"
```

### 5. Отправка данных в удалённый репозиторий

Передача коммитов на сервер:

```
git push origin имя_ветки
```

### 6. Получение обновлений с сервера

Загрузка и объединение удалённых изменений:

```
git pull origin имя_ветки
```

### 7. Просмотр истории версий

Краткий список коммитов:

```
git log
```

Расширенная информация о каждом коммите:

```
git log --summary
```

### 8. Подключение удалённого репозитория

Связывание локального проекта с репозиторием на GitHub / GitLab (через PAT):

```
git remote add origin URL_репозитория
```

### 9. Сравнение изменений

Различия между рабочей версией и последним коммитом:

```
git diff HEAD
```

Различия между индексом (stage) и последним коммитом:

```
git diff --staged
```

### 10. Отмена подготовки файлов

Убрать файлы из области stage:

```
git reset имя_файла
```

### 11. Отмена локальных изменений

Возврат файла к состоянию последнего коммита:

```
git checkout -- имя_файла
```

### 12. Работа с ветками

Создание новой ветки:

```
git branch имя_ветки
```

Переход на другую ветку:

```
git checkout имя_ветки
```

Удаление ветки:

```
git branch -d имя_ветки
```

### 13. Слияние веток

Объединение указанной ветки с текущей:

```
git merge имя_ветки
```